package view;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Observable;
import java.util.Observer;

import javax.swing.JPanel;

import model.Board;
import model.MineException;

public class BoardView extends JPanel implements Observer{

	private Board board;
	private BoxDrawer boxDrawer;
	private static final long serialVersionUID = 1L;
	

	public BoardView(Board board, BoxDrawer drawer) {
		super();
		this.board = board;
		this.boxDrawer = drawer;
		this.setSize(30*board.getWidth(),30*board.getHeight());
		board.addObserver(this);
	}

	@Override
	public void update(Observable o, Object arg) {
		this.repaint();
	}
	
	@Override
	protected void paintComponent(Graphics g) {
		super.paintComponent(g);
		for (int i = 0; i < board.getWidth();i++) {
			for (int j = 0; j < board.getHeight(); j++) {
				boxDrawer.draw(board.getBoard()[i][j], g, i, j);
				if (board.getBoard()[i][j].hasBeenSelected()) {
					g.setColor(Color.WHITE);
					try {
						g.drawString(""+board.selectBox(i, j), i*30+10, j*30+20);
					} catch (MineException e) {
					}
				}
			}
		}
	}

}
